/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    aic3106.c
 *
 * \brief   Routines to initialize the AIC3106 Audio Coded
 *
 * This file contains the routines for configuring and
 * accessing the AIC3106 Audio Codec
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_i2c.h"
#include "aic3106.h"
  
/*
 *====================
 * Function implementations
 *====================
 */
/** **************************************************************************
 * \n \brief Routine to set the register value in the AIC3106 Codec
 *
 * This routine initializes the I2C instance 0. We are not configuring the 
 * interrupts here as the code is intended to carry out all I/O operations
 * in polled mode.
 *
 * \param u8RegNum		[IN]	Bus Instance number
 * \param u8RegVal		[IN]	Value to be written
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS aic3106RegSet
(
	UINT8	u8RegNum,
	UINT8  	u8RegVal
)
{
	STATUS u32RetVal = SUCCESS;
	UINT8  u8DataWritten = 0;
	
	UINT8	au8Cmd[32];
	
	au8Cmd[0] = u8RegNum & AIC3106_REG_ADDR_MASK;
	au8Cmd[1] = u8RegVal;
	
	u32RetVal = DM814xI2cWite (AIC3106_I2C_BUS_NUM, 
								AIC3106_I2C_ADDR,
								au8Cmd,
								2,
								&u8DataWritten );
	
	return (u32RetVal);
}
